/*
 * Decompiled with CFR 0.152.
 */
package emulator.hardware.io.peripherals.iec;

import emulator.hardware.CPU;
import emulator.hardware.HwByte;
import emulator.hardware.clock.Clock;
import emulator.hardware.clock.ClockHandle;
import emulator.hardware.io.peripherals.IecPort;
import emulator.hardware.io.peripherals.iec.DeviceInfo;
import emulator.hardware.io.peripherals.iec.IecLog;
import emulator.hardware.io.peripherals.iec.IecSimDevice;
import emulator.hardware.io.peripherals.iec.IecSimDeviceFactory;
import emulator.hardware.io.peripherals.iec.IecSimDeviceRegistry;
import emulator.hardware.io.peripherals.iec.sim.Action;
import emulator.hardware.io.peripherals.iec.sim.CompoundState;
import emulator.hardware.io.peripherals.iec.sim.Condition;
import emulator.hardware.io.peripherals.iec.sim.Edge;
import emulator.hardware.io.peripherals.iec.sim.Effect;
import emulator.hardware.io.peripherals.iec.sim.Event;
import emulator.hardware.io.peripherals.iec.sim.IecWorld;
import emulator.hardware.io.peripherals.iec.sim.MachineState;
import emulator.hardware.io.peripherals.iec.sim.StateMachine;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IecSim
extends Thread {
    static Logger logger = LogManager.getLogger((String)IecSim.class.getName());
    private static final int T_VALID = 70;
    private static final int T_SETUP = 70;
    private static final int RCVBUF_MAX = 65536;
    private ClockHandle clock = null;
    protected IecWorld iecWorld = null;
    private IecLog log = null;
    private boolean is_state_log_enabled = false;
    private ByteBuffer buffer = ByteBuffer.allocate(65536);
    private HashMap<Integer, IecSimDevice> device_map = null;
    private IecSimDevice active_device = null;
    private IecSimDeviceFactory factory = new IecSimDeviceFactory();
    private long lastClock;
    private int portLastValue = 0;
    private StateMachine _iecMachine = null;
    private CPU _cpu;
    protected int _nextToSend;

    public IecSim(CPU cpu) {
        this._cpu = cpu;
        this.log = new IecLog();
        this.initDevices();
        IecSimDeviceRegistry.instance().addObserver(new DeviceRegistryObserver());
    }

    private synchronized void initDevices() {
        logger.entry();
        this.active_device = null;
        this.device_map = new HashMap();
        int[] device_numbers = IecSimDeviceRegistry.instance().enumDevices();
        int i = 0;
        while (i < device_numbers.length) {
            IecSimDevice device;
            DeviceInfo device_info = IecSimDeviceRegistry.instance().getDevice(device_numbers[i]);
            if (device_info != null && (device = this.factory.createDevice(device_info)) != null) {
                this.addDevice(device, device_info.getAddress());
            }
            ++i;
        }
    }

    private void addDevice(IecSimDevice device, int address) {
        logger.info("Adding device #" + address + " " + device);
        this.device_map.put(address, device);
        device.setIecSim(this);
    }

    public void attach(Clock clock, IecPort port) {
        if (clock != null) {
            this.clock = clock.acquireHandle();
        }
        this.iecWorld = new IecWorld(port);
        this.lastClock = this.clock.getTicks();
        this.initMachine();
    }

    Effect logEffect(String text) {
        return new LogEffect(text);
    }

    Action logAction(String text) {
        return new Action(new Effect[]{new LogEffect(text)});
    }

    Effect logData(String direction, boolean isAtn) {
        return new ReportByteEffect(direction, isAtn);
    }

    Effect clearBuffer() {
        return new Effect(){

            @Override
            public void execute() {
                IecSim.this.buffer.clear();
            }
        };
    }

    Effect putData() {
        return new Effect(){

            @Override
            public void execute() {
                IecSim.this.buffer.put((byte)IecSim.this.iecWorld.getDataByte());
            }
        };
    }

    Effect processBuffer(boolean isAtn) {
        return new ProcessBuffer(isAtn);
    }

    Effect initSend() {
        return new Effect(){

            @Override
            public void execute() {
                logger.debug("initSend for device " + IecSim.this.active_device);
                IecSim.this.iecWorld.setDataByte(IecSim.this.active_device != null ? IecSim.this.active_device.read() : -1);
            }
        };
    }

    Effect brk() {
        return new Effect(){

            @Override
            public void execute() {
                IecSim.this.log("<BRK>");
                IecSim.this._cpu.halt();
            }
        };
    }

    Condition hasToSend() {
        return new Condition(){

            @Override
            public boolean evaluate() {
                return IecSim.this.iecWorld.getDataByte() >= 0;
            }
        };
    }

    Effect peekNext() {
        return new Effect(){

            @Override
            public void execute() {
                IecSim.this._nextToSend = IecSim.this.active_device.read();
                IecSim.this.iecWorld.SET_EOI(IecSim.this._nextToSend < 0).execute();
            }
        };
    }

    Effect sendNext() {
        return new Effect(){

            @Override
            public void execute() {
                IecSim.this.iecWorld.setDataByte(IecSim.this._nextToSend);
            }
        };
    }

    Condition deviceActive() {
        return new Condition(){

            @Override
            public boolean evaluate() {
                return IecSim.this.active_device != null;
            }
        };
    }

    public void initMachine() {
        CompoundState Attention = this.initAtnMachine();
        CompoundState Talk = this.initTalkMachine();
        CompoundState Listen = this.initListenMachine();
        MachineState Idle = new MachineState("IDLE").addEdge(new Event(new Condition[]{this.iecWorld.ATN}), this.logAction("IDL->ATN"), Attention);
        Attention.addEdge(new Event(new Condition[]{this.iecWorld.nATN, this.iecWorld.TALK}), this.logAction("ATN->TLK"), Talk).addEdge(new Event(new Condition[]{this.iecWorld.nATN, this.iecWorld.LISTEN}), this.logAction("ATN->LSN"), Listen).addEdge(new Event(new Condition[]{this.iecWorld.nATN}), new Action(new Effect[]{this.logEffect("ATN->IDL"), this.iecWorld.RELEASE_CLK, this.iecWorld.RELEASE_DATA}), Idle);
        Talk.addEdge(new Event(new Condition[]{this.iecWorld.ATN}), this.logAction("TLK->ATN"), Attention).addEdge(new Event(new Condition[]{this.iecWorld.nTALK, this.iecWorld.LISTEN}), this.logAction("TLK->LSN"), Listen).addEdge(new Event(new Condition[]{this.iecWorld.nTALK}), new Action(new Effect[]{this.logEffect("TLK->IDL"), this.iecWorld.RELEASE_CLK, this.iecWorld.RELEASE_DATA}), Idle);
        Listen.addEdge(new Event(new Condition[]{this.iecWorld.ATN}), this.logAction("LSN->ATN"), Attention).addEdge(new Event(new Condition[]{this.iecWorld.nLISTEN, this.iecWorld.TALK}), this.logAction("LSN->TLK"), Talk).addEdge(new Event(new Condition[]{this.iecWorld.nLISTEN}), new Action(new Effect[]{this.logEffect("LSN->IDL"), this.iecWorld.RELEASE_CLK, this.iecWorld.RELEASE_DATA}), Idle);
        this._iecMachine = new StateMachine(new Edge(IecWorld.TRUE, new Action(new Effect[]{this.iecWorld.RELEASE_CLK, this.iecWorld.RELEASE_DATA, this.iecWorld.END_RECEIVE, this.iecWorld.END_SEND, this.logEffect("INIT->IDL")}), Idle));
    }

    public CompoundState initListenMachine() {
        MachineState initListen = new MachineState("LSN:INIT");
        MachineState waitForStart = new MachineState("LSN:WAIT_STX");
        MachineState waitForClock = new MachineState("LSN:WAIT_CLK");
        MachineState waitEoiHandshake = new MachineState("LSN:WAIT_EOI");
        MachineState waitForClock2 = new MachineState("LSN:WAIT_CLK2");
        MachineState waitBit0 = new MachineState("LSN:WAIT_BIT0");
        MachineState gotBit0 = new MachineState("LSN:GOT_BIT0");
        MachineState waitBit1 = new MachineState("LSN:WAIT_BIT1");
        MachineState gotBit1 = new MachineState("LSN:GOT_BIT1");
        MachineState waitBit2 = new MachineState("LSN:WAIT_BIT2");
        MachineState gotBit2 = new MachineState("LSN:GOT_BIT2");
        MachineState waitBit3 = new MachineState("LSN:WAIT_BIT3");
        MachineState gotBit3 = new MachineState("LSN:GOT_BIT3");
        MachineState waitBit4 = new MachineState("LSN:WAIT_BIT4");
        MachineState gotBit4 = new MachineState("LSN:GOT_BIT4");
        MachineState waitBit5 = new MachineState("LSN:WAIT_BIT5");
        MachineState gotBit5 = new MachineState("LSN:GOT_BIT5");
        MachineState waitBit6 = new MachineState("LSN:WAIT_BIT6");
        MachineState gotBit6 = new MachineState("LSN:GOT_BIT6");
        MachineState waitBit7 = new MachineState("LSN:WAIT_BIT7");
        MachineState gotBit7 = new MachineState("LSN:GOT_BIT7");
        MachineState endFrame = new MachineState("LSN:END_FRM");
        MachineState finish = new MachineState("LSN:FIN");
        initListen.addEdge(new Event(new Condition[]{this.iecWorld.nDATA}), new Action(new Effect[]{this.logEffect("LSN:->waitSTX"), this.iecWorld.PULL_DATA, this.iecWorld.SET_EOI(false)}), waitForStart);
        waitForStart.addEdge(new Event(new Condition[]{this.iecWorld.nCLK}), new Action(new Effect[]{this.logEffect("LSN:waitSTX->waitClk"), this.iecWorld.RELEASE_DATA, this.iecWorld.SET_TIMEOUT(256)}), waitForClock);
        waitForClock.addEdge(new Event(new Condition[]{this.iecWorld.CLK}), new Action(new Effect[]{this.logEffect("LSN:waitClk->wb0")}), waitBit0).addEdge(new Event(new Condition[]{this.iecWorld.TIMEOUT}), new Action(new Effect[]{this.logEffect("LSN:waitClk->waitEOI"), this.iecWorld.PULL_DATA, this.iecWorld.SET_EOI(true), this.iecWorld.SET_TIMEOUT(60)}), waitEoiHandshake);
        waitEoiHandshake.addEdge(new Event(new Condition[]{this.iecWorld.TIMEOUT}), new Action(new Effect[]{this.logEffect("LSN:waitEoi->waitClk2"), this.iecWorld.RELEASE_DATA}), waitForClock2);
        waitForClock2.addEdge(new Event(new Condition[]{this.iecWorld.CLK}), new Action(new Effect[]{this.logEffect("LSN:waitClk2->wb0")}), waitBit0);
        waitBit0.addEdge(new Event(new Condition[]{this.iecWorld.nCLK}), new Action(new Effect[]{this.logEffect("LSN:wb0->gb0"), this.iecWorld.RCV_BIT(0)}), gotBit0);
        gotBit0.addEdge(new Event(new Condition[]{this.iecWorld.CLK}), new Action(new Effect[]{this.logEffect("LSN:gb0->wb1")}), waitBit1);
        waitBit1.addEdge(new Event(new Condition[]{this.iecWorld.nCLK}), new Action(new Effect[]{this.logEffect("LSN:wb1->gb1"), this.iecWorld.RCV_BIT(1)}), gotBit1);
        gotBit1.addEdge(new Event(new Condition[]{this.iecWorld.CLK}), new Action(new Effect[]{this.logEffect("LSN:gb1->wb2")}), waitBit2);
        waitBit2.addEdge(new Event(new Condition[]{this.iecWorld.nCLK}), new Action(new Effect[]{this.logEffect("LSN:wb2->gb2"), this.iecWorld.RCV_BIT(2)}), gotBit2);
        gotBit2.addEdge(new Event(new Condition[]{this.iecWorld.CLK}), new Action(new Effect[]{this.logEffect("LSN:gb2->wb3")}), waitBit3);
        waitBit3.addEdge(new Event(new Condition[]{this.iecWorld.nCLK}), new Action(new Effect[]{this.logEffect("LSN:wb3->gb3"), this.iecWorld.RCV_BIT(3)}), gotBit3);
        gotBit3.addEdge(new Event(new Condition[]{this.iecWorld.CLK}), new Action(new Effect[]{this.logEffect("LSN:gb3->wb4")}), waitBit4);
        waitBit4.addEdge(new Event(new Condition[]{this.iecWorld.nCLK}), new Action(new Effect[]{this.logEffect("LSN:wb4->gb4"), this.iecWorld.RCV_BIT(4)}), gotBit4);
        gotBit4.addEdge(new Event(new Condition[]{this.iecWorld.CLK}), new Action(new Effect[]{this.logEffect("LSN:gb4->wb5")}), waitBit5);
        waitBit5.addEdge(new Event(new Condition[]{this.iecWorld.nCLK}), new Action(new Effect[]{this.logEffect("LSN:wb5->gb5"), this.iecWorld.RCV_BIT(5)}), gotBit5);
        gotBit5.addEdge(new Event(new Condition[]{this.iecWorld.CLK}), new Action(new Effect[]{this.logEffect("LSN:gb5->wb6")}), waitBit6);
        waitBit6.addEdge(new Event(new Condition[]{this.iecWorld.nCLK}), new Action(new Effect[]{this.logEffect("LSN:wb6->gb6"), this.iecWorld.RCV_BIT(6)}), gotBit6);
        gotBit6.addEdge(new Event(new Condition[]{this.iecWorld.CLK}), new Action(new Effect[]{this.logEffect("LSN:gb6->wb7")}), waitBit7);
        waitBit7.addEdge(new Event(new Condition[]{this.iecWorld.nCLK}), new Action(new Effect[]{this.logEffect("LSN:wb7->gb7"), this.iecWorld.RCV_BIT(7), this.logData("(IN)", false), this.putData()}), gotBit7);
        gotBit7.addEdge(new Event(new Condition[]{this.iecWorld.CLK}), new Action(new Effect[]{this.logEffect("LSN:gb7->endFrm"), this.iecWorld.PULL_DATA, this.iecWorld.SET_TIMEOUT(60)}), endFrame);
        endFrame.addEdge(new Event(new Condition[]{this.iecWorld.TIMEOUT, this.iecWorld.EOI}), new Action(new Effect[]{this.logEffect("LSN:endFrm->fin"), this.iecWorld.RELEASE_DATA, this.processBuffer(false)}), finish).addEdge(new Event(new Condition[]{this.iecWorld.TIMEOUT}), new Action(new Effect[]{this.logEffect("LSN:endFrm->initListen"), this.iecWorld.RELEASE_DATA}), initListen);
        return new CompoundState("LISTEN", new StateMachine(new Edge(IecWorld.TRUE, new Action(new Effect[]{this.logEffect("LSN:INIT"), this.clearBuffer(), this.iecWorld.RELEASE_DATA}), initListen)));
    }

    public CompoundState initTalkMachine() {
        MachineState talkAtnRelease = new MachineState("TLK:turnAround");
        MachineState initTalk = new MachineState("TLK:init");
        MachineState noData = new MachineState("TLK:noData");
        MachineState waitClkIdle = new MachineState("waitClkIdle");
        MachineState waitStartDataLow = new MachineState("TLK:waitStartDataLow");
        MachineState deviceNotPresent = new MachineState("TLK:deviceNotPresent");
        MachineState waitStartDataHigh = new MachineState("TLK:waitStartDataHigh");
        MachineState signalEoi = new MachineState("TLK:signalEoi");
        MachineState waitStartDataHigh2 = new MachineState("TLK:waitStartDataHigh2");
        MachineState waitStartDataHigh3 = new MachineState("TLK:waitStartDataHigh3");
        MachineState setupBit0 = new MachineState("TLK:setupBit0");
        MachineState holdBit0 = new MachineState("TLK:holdBit0");
        MachineState setupBit1 = new MachineState("TLK:setupBit1");
        MachineState holdBit1 = new MachineState("TLK:holdBit1");
        MachineState setupBit2 = new MachineState("TLK:setupBit2");
        MachineState holdBit2 = new MachineState("TLK:holdBit2");
        MachineState setupBit3 = new MachineState("TLK:setupBit3");
        MachineState holdBit3 = new MachineState("TLK:holdBit3");
        MachineState setupBit4 = new MachineState("TLK:setupBit4");
        MachineState holdBit4 = new MachineState("TLK:holdBit4");
        MachineState setupBit5 = new MachineState("TLK:setupBit5");
        MachineState holdBit5 = new MachineState("TLK:holdBit5");
        MachineState setupBit6 = new MachineState("TLK:setupBit6");
        MachineState holdBit6 = new MachineState("TLK:holdBit6");
        MachineState setupBit7 = new MachineState("TLK:setupBit7");
        MachineState holdBit7 = new MachineState("TLK:holdBit7");
        MachineState waitAck = new MachineState("TLK:waitAck");
        MachineState waitBetweenFrames = new MachineState("TLK:waitBeweenFrames");
        talkAtnRelease.addEdge(new Event(new Condition[]{this.iecWorld.TIMEOUT}), new Action(new Effect[]{this.logEffect("TLK:turnAround->initTalk"), this.iecWorld.RELEASE_CLK, this.iecWorld.SET_TIMEOUT(0)}), initTalk);
        initTalk.addEdge(new Event(new Condition[]{this.hasToSend()}), new Action(new Effect[]{this.logEffect("TLK:init->waitClkIdle")}), waitClkIdle).addEdge(new Event(new Condition[]{this.iecWorld.TIMEOUT}), new Action(new Effect[]{this.logEffect("TLK:init->noData")}), noData);
        waitClkIdle.addEdge(new Event(new Condition[]{this.iecWorld.nCLK}), new Action(new Effect[]{this.logEffect("waitClkIdle->waitStartDataLow"), this.iecWorld.PULL_CLK, this.iecWorld.SET_TIMEOUT(256)}), waitStartDataLow);
        waitStartDataLow.addEdge(new Event(new Condition[]{this.iecWorld.DATA}), new Action(new Effect[]{this.logEffect("TLK:waitStartDataLow->waitStartDataHigh"), this.iecWorld.RELEASE_CLK, this.peekNext(), this.logData("(OUT)", false)}), waitStartDataHigh).addEdge(new Event(new Condition[]{this.iecWorld.TIMEOUT}), new Action(new Effect[]{this.logEffect("TLK:waitStartDataLow->deviceNotPresent"), this.iecWorld.RELEASE_CLK, this.brk()}), deviceNotPresent);
        waitStartDataHigh.addEdge(new Event(new Condition[]{this.iecWorld.nDATA, this.iecWorld.EOI}), new Action(new Effect[]{this.logEffect("TLK:waitStartDataHigh->signalEoi")}), signalEoi).addEdge(new Event(new Condition[]{this.iecWorld.nEOI}), new Action(new Effect[]{this.logEffect("TLK:waitStartDataHigh->waitStartDataHigh2"), this.iecWorld.SET_TIMEOUT(25)}), waitStartDataHigh2);
        signalEoi.addEdge(new Event(new Condition[]{this.iecWorld.DATA}), new Action(new Effect[]{this.logEffect("TLK:signalEoi->waitStartDataHigh2"), this.iecWorld.SET_TIMEOUT(25)}), waitStartDataHigh2);
        waitStartDataHigh2.addEdge(new Event(new Condition[]{this.iecWorld.nDATA}), new Action(new Effect[]{this.logEffect("TLK:waitStartDataHigh2->setupBit0"), this.iecWorld.PULL_CLK, this.iecWorld.SET_TIMEOUT(70)}), setupBit0).addEdge(new Event(new Condition[]{this.iecWorld.TIMEOUT}), new Action(new Effect[0]), waitStartDataHigh3);
        waitStartDataHigh3.addEdge(new Event(new Condition[]{this.iecWorld.nDATA}), new Action(new Effect[]{this.logEffect("TLK:waitStartDataHigh3->setupBit0"), this.iecWorld.PULL_CLK, this.iecWorld.SET_TIMEOUT(70)}), setupBit0);
        setupBit0.addEdge(new Event(new Condition[]{this.iecWorld.TIMEOUT}), new Action(new Effect[]{this.logEffect("TLK:setupBit0->holdBit0"), this.iecWorld.SND_BIT(0), this.iecWorld.RELEASE_CLK, this.iecWorld.SET_TIMEOUT(70)}), holdBit0);
        holdBit0.addEdge(new Event(new Condition[]{this.iecWorld.TIMEOUT}), new Action(new Effect[]{this.logEffect("TLK:holdBit0->setupBit1"), this.iecWorld.PULL_CLK, this.iecWorld.SET_TIMEOUT(70)}), setupBit1);
        setupBit1.addEdge(new Event(new Condition[]{this.iecWorld.TIMEOUT}), new Action(new Effect[]{this.logEffect("TLK:setupBit1->holdBit1"), this.iecWorld.SND_BIT(1), this.iecWorld.RELEASE_CLK, this.iecWorld.SET_TIMEOUT(70)}), holdBit1);
        holdBit1.addEdge(new Event(new Condition[]{this.iecWorld.TIMEOUT}), new Action(new Effect[]{this.logEffect("TLK:holdBit1->setupBit2"), this.iecWorld.PULL_CLK, this.iecWorld.SET_TIMEOUT(70)}), setupBit2);
        setupBit2.addEdge(new Event(new Condition[]{this.iecWorld.TIMEOUT}), new Action(new Effect[]{this.logEffect("TLK:setupBit2->holdBit2"), this.iecWorld.SND_BIT(2), this.iecWorld.RELEASE_CLK, this.iecWorld.SET_TIMEOUT(70)}), holdBit2);
        holdBit2.addEdge(new Event(new Condition[]{this.iecWorld.TIMEOUT}), new Action(new Effect[]{this.logEffect("TLK:holdBit2->setupBit3"), this.iecWorld.PULL_CLK, this.iecWorld.SET_TIMEOUT(70)}), setupBit3);
        setupBit3.addEdge(new Event(new Condition[]{this.iecWorld.TIMEOUT}), new Action(new Effect[]{this.logEffect("TLK:setupBit3->holdBit3"), this.iecWorld.SND_BIT(3), this.iecWorld.RELEASE_CLK, this.iecWorld.SET_TIMEOUT(70)}), holdBit3);
        holdBit3.addEdge(new Event(new Condition[]{this.iecWorld.TIMEOUT}), new Action(new Effect[]{this.logEffect("TLK:holdBit3->setupBit4"), this.iecWorld.PULL_CLK, this.iecWorld.SET_TIMEOUT(70)}), setupBit4);
        setupBit4.addEdge(new Event(new Condition[]{this.iecWorld.TIMEOUT}), new Action(new Effect[]{this.logEffect("TLK:setupBit4->holdBit4"), this.iecWorld.SND_BIT(4), this.iecWorld.RELEASE_CLK, this.iecWorld.SET_TIMEOUT(70)}), holdBit4);
        holdBit4.addEdge(new Event(new Condition[]{this.iecWorld.TIMEOUT}), new Action(new Effect[]{this.logEffect("TLK:holdBit4->setupBit5"), this.iecWorld.PULL_CLK, this.iecWorld.SET_TIMEOUT(70)}), setupBit5);
        setupBit5.addEdge(new Event(new Condition[]{this.iecWorld.TIMEOUT}), new Action(new Effect[]{this.logEffect("TLK:setupBit5->holdBit5"), this.iecWorld.SND_BIT(5), this.iecWorld.RELEASE_CLK, this.iecWorld.SET_TIMEOUT(70)}), holdBit5);
        holdBit5.addEdge(new Event(new Condition[]{this.iecWorld.TIMEOUT}), new Action(new Effect[]{this.logEffect("TLK:holdBit5->setupBit6"), this.iecWorld.PULL_CLK, this.iecWorld.SET_TIMEOUT(70)}), setupBit6);
        setupBit6.addEdge(new Event(new Condition[]{this.iecWorld.TIMEOUT}), new Action(new Effect[]{this.logEffect("TLK:setupBit6->holdBit6"), this.iecWorld.SND_BIT(6), this.iecWorld.RELEASE_CLK, this.iecWorld.SET_TIMEOUT(70)}), holdBit6);
        holdBit6.addEdge(new Event(new Condition[]{this.iecWorld.TIMEOUT}), new Action(new Effect[]{this.logEffect("TLK:holdBit6->setupBit7"), this.iecWorld.PULL_CLK, this.iecWorld.SET_TIMEOUT(70)}), setupBit7);
        setupBit7.addEdge(new Event(new Condition[]{this.iecWorld.TIMEOUT}), new Action(new Effect[]{this.logEffect("TLK:setupBit7->holdBit7"), this.iecWorld.SND_BIT(7), this.iecWorld.RELEASE_CLK, this.iecWorld.SET_TIMEOUT(70)}), holdBit7);
        holdBit7.addEdge(new Event(new Condition[]{this.iecWorld.TIMEOUT}), new Action(new Effect[]{this.logEffect("TLK:holdBit7->waitAck"), this.iecWorld.PULL_CLK, this.iecWorld.RELEASE_DATA}), waitAck);
        waitAck.addEdge(new Event(new Condition[]{this.iecWorld.DATA}), new Action(new Effect[]{this.logEffect("TLK:waitAck->waitBetweenFrames"), this.iecWorld.SET_TIMEOUT(200)}), waitBetweenFrames);
        waitBetweenFrames.addEdge(new Event(new Condition[]{this.iecWorld.TIMEOUT}), new Action(new Effect[]{this.logEffect("TLK:waitBetweenFrames->waitStartDataHigh"), this.sendNext(), this.iecWorld.RELEASE_CLK, this.peekNext(), this.logData("(OUT)", false)}), waitStartDataHigh).addEdge(new Event(new Condition[]{this.iecWorld.EOI}), new Action(new Effect[]{this.logEffect("TLK:waitBetweenFrames->noData"), this.iecWorld.END_SEND, this.iecWorld.RELEASE_CLK}), noData).addEdge(new Event(new Condition[]{this.iecWorld.nDATA}), new Action(new Effect[]{this.logEffect("TLK:waitBetweenFrames->waitStartDataLow"), this.sendNext(), this.iecWorld.RELEASE_CLK, this.iecWorld.SET_TIMEOUT(2000)}), waitStartDataLow);
        return new CompoundState("TALK", new StateMachine(new Edge(IecWorld.TRUE, new Action(new Effect[]{this.logEffect("TLK:->talkAtnRelease"), this.initSend(), this.iecWorld.SET_TIMEOUT(100), this.iecWorld.PULL_CLK, this.iecWorld.RELEASE_DATA}), talkAtnRelease)));
    }

    public CompoundState initAtnMachine() {
        MachineState initAtn = new MachineState("ATN:INIT");
        MachineState waitForStart = new MachineState("ATN:WAIT_STX");
        MachineState waitForClock = new MachineState("ATN:WAIT_CLK");
        MachineState waitBit0 = new MachineState("ATN:WAIT_BIT0");
        MachineState gotBit0 = new MachineState("ATN:GOT_BIT0");
        MachineState waitBit1 = new MachineState("ATN:WAIT_BIT1");
        MachineState gotBit1 = new MachineState("ATN:GOT_BIT1");
        MachineState waitBit2 = new MachineState("ATN:WAIT_BIT2");
        MachineState gotBit2 = new MachineState("ATN:GOT_BIT2");
        MachineState waitBit3 = new MachineState("ATN:WAIT_BIT3");
        MachineState gotBit3 = new MachineState("ATN:GOT_BIT3");
        MachineState waitBit4 = new MachineState("ATN:WAIT_BIT4");
        MachineState gotBit4 = new MachineState("ATN:GOT_BIT4");
        MachineState waitBit5 = new MachineState("ATN:WAIT_BIT5");
        MachineState gotBit5 = new MachineState("ATN:GOT_BIT5");
        MachineState waitBit6 = new MachineState("ATN:WAIT_BIT6");
        MachineState gotBit6 = new MachineState("ATN:GOT_BIT6");
        MachineState waitBit7 = new MachineState("ATN:WAIT_BIT7");
        MachineState gotBit7 = new MachineState("ATN:GOT_BIT7");
        MachineState endFrame = new MachineState("ATN:END_FRM");
        MachineState finish = new MachineState("ATN:FIN");
        initAtn.addEdge(new Event(new Condition[]{this.iecWorld.CLK}), new Action(new Effect[]{this.logEffect("ATN:->waitSTX"), this.iecWorld.PULL_DATA}), waitForStart);
        waitForStart.addEdge(new Event(new Condition[]{this.iecWorld.nCLK}), new Action(new Effect[]{this.logEffect("ATN:waitSTX->waitClk"), this.iecWorld.RELEASE_DATA}), waitForClock);
        waitForClock.addEdge(new Event(new Condition[]{this.iecWorld.CLK}), new Action(new Effect[]{this.logEffect("ATN:waitClk->wb0")}), waitBit0);
        waitBit0.addEdge(new Event(new Condition[]{this.iecWorld.nCLK}), new Action(new Effect[]{this.logEffect("ATN:wb0->gb0"), this.iecWorld.RCV_BIT(0)}), gotBit0);
        gotBit0.addEdge(new Event(new Condition[]{this.iecWorld.CLK}), new Action(new Effect[]{this.logEffect("ATN:gb0->wb1")}), waitBit1);
        waitBit1.addEdge(new Event(new Condition[]{this.iecWorld.nCLK}), new Action(new Effect[]{this.logEffect("ATN:wb1->gb1"), this.iecWorld.RCV_BIT(1)}), gotBit1);
        gotBit1.addEdge(new Event(new Condition[]{this.iecWorld.CLK}), new Action(new Effect[]{this.logEffect("ATN:gb1->wb2")}), waitBit2);
        waitBit2.addEdge(new Event(new Condition[]{this.iecWorld.nCLK}), new Action(new Effect[]{this.logEffect("ATN:wb2->gb2"), this.iecWorld.RCV_BIT(2)}), gotBit2);
        gotBit2.addEdge(new Event(new Condition[]{this.iecWorld.CLK}), new Action(new Effect[]{this.logEffect("ATN:gb2->wb3")}), waitBit3);
        waitBit3.addEdge(new Event(new Condition[]{this.iecWorld.nCLK}), new Action(new Effect[]{this.logEffect("ATN:wb3->gb3"), this.iecWorld.RCV_BIT(3)}), gotBit3);
        gotBit3.addEdge(new Event(new Condition[]{this.iecWorld.CLK}), new Action(new Effect[]{this.logEffect("ATN:gb3->wb4")}), waitBit4);
        waitBit4.addEdge(new Event(new Condition[]{this.iecWorld.nCLK}), new Action(new Effect[]{this.logEffect("ATN:wb4->gb4"), this.iecWorld.RCV_BIT(4)}), gotBit4);
        gotBit4.addEdge(new Event(new Condition[]{this.iecWorld.CLK}), new Action(new Effect[]{this.logEffect("ATN:gb4->wb5")}), waitBit5);
        waitBit5.addEdge(new Event(new Condition[]{this.iecWorld.nCLK}), new Action(new Effect[]{this.logEffect("ATN:wb5->gb5"), this.iecWorld.RCV_BIT(5)}), gotBit5);
        gotBit5.addEdge(new Event(new Condition[]{this.iecWorld.CLK}), new Action(new Effect[]{this.logEffect("ATN:gb5->wb6")}), waitBit6);
        waitBit6.addEdge(new Event(new Condition[]{this.iecWorld.nCLK}), new Action(new Effect[]{this.logEffect("ATN:wb6->gb6"), this.iecWorld.RCV_BIT(6)}), gotBit6);
        gotBit6.addEdge(new Event(new Condition[]{this.iecWorld.CLK}), new Action(new Effect[]{this.logEffect("ATN:gb6->wb7")}), waitBit7);
        waitBit7.addEdge(new Event(new Condition[]{this.iecWorld.nCLK}), new Action(new Effect[]{this.logEffect("ATN:wb7->gb7"), this.iecWorld.RCV_BIT(7), this.logData("(IN)", true), new Effect(){

            @Override
            public void execute() {
                IecSim.this.checkCommand(IecSim.this.iecWorld.getDataByte());
            }
        }}), gotBit7);
        gotBit7.addEdge(new Event(new Condition[]{this.iecWorld.CLK}), new Action(new Effect[]{this.logEffect("ATN:gb7->endFrm"), this.iecWorld.PULL_DATA, this.iecWorld.SET_TIMEOUT(60)}), endFrame);
        endFrame.addEdge(new Event(new Condition[]{this.iecWorld.TIMEOUT}), new Action(new Effect[]{this.logEffect("ATN:endFrm->finish"), this.iecWorld.RELEASE_DATA, this.putData(), this.processBuffer(true), this.clearBuffer()}), finish);
        finish.addEdge(new Event(new Condition[]{this.deviceActive()}), this.logAction("ATN:finish->initAtn"), initAtn);
        return new CompoundState("ATN", new StateMachine(new Edge(IecWorld.TRUE, new Action(new Effect[]{this.iecWorld.RELEASE_CLK, this.iecWorld.RELEASE_DATA, this.iecWorld.END_RECEIVE, this.iecWorld.END_SEND, this.logEffect("ATN:INIT"), this.clearBuffer(), this.iecWorld.SET_EOI(false)}), initAtn)));
    }

    public void detach() {
        this.clock = null;
    }

    @Override
    public void run() {
        this._iecMachine.reset();
        try {
            while (true) {
                this.clock.tick();
                this.iecWorld.tick();
                this._iecMachine.tick();
                this.trackPort();
            }
        }
        catch (Exception ex) {
            logger.error("Unexpected failure in IEC simulation", (Throwable)ex);
            return;
        }
    }

    private void trackPort() {
        if (this.getPortValue() != this.portLastValue && this.clock.getTicks() - this.lastClock > 0L) {
            this.logState("CHG");
        }
    }

    public int getPortValue() {
        return (this.iecWorld.getAtnIn() ? 1 : 0) | (this.iecWorld.getClkIn() ? 2 : 0) | (this.iecWorld.getDataIn() ? 4 : 0);
    }

    private void processData(boolean is_atn) {
        logger.entry();
        if (this.active_device != null) {
            if (is_atn) {
                this.active_device.processCommand(this.buffer);
            } else {
                this.active_device.processData(this.buffer);
            }
        }
    }

    private void checkCommand(int cmd) {
        logger.debug("checking command " + new HwByte((long)cmd) + "h, active device=" + this.active_device);
        if ((cmd & 0xE0) == 32 || (cmd & 0xE0) == 64) {
            if (cmd == 63 || cmd == 95) {
                if (this.active_device != null) {
                    if (cmd == 63) {
                        this.active_device.unlisten();
                    } else {
                        this.active_device.untalk();
                    }
                    this.active_device = null;
                }
            } else {
                this.active_device = null;
                int address = cmd & 0x1F;
                if (this.device_map.containsKey(address)) {
                    this.active_device = this.device_map.get(address);
                    logger.debug("active device for command " + new HwByte((long)cmd) + "h =" + this.active_device);
                    if ((cmd & 0xE0) == 32) {
                        this.active_device.listen();
                    } else {
                        this.active_device.talk();
                    }
                }
            }
        }
    }

    protected void reportByte(String dir, boolean is_atn, int data) {
        String log_string = String.valueOf(dir) + " " + (is_atn ? "/" : " ") + new HwByte((long)data) + " - ";
        if (is_atn) {
            log_string = data >= 32 && data < 63 ? String.valueOf(log_string) + "LISTEN #" + (data & 0x1F) : (data == 63 ? String.valueOf(log_string) + "UNLISTEN" : (data >= 64 && data < 95 ? String.valueOf(log_string) + "TALK #" + (data & 0x1F) : (data == 95 ? String.valueOf(log_string) + "UNTALK" : (data >= 96 && data < 112 ? String.valueOf(log_string) + "OPEN CHN/DATA #" + (data & 0xF) : (data >= 224 && data < 240 ? String.valueOf(log_string) + "CLOSE #" + (data & 0xF) : (data >= 240 ? String.valueOf(log_string) + "OPEN #" + (data & 0xF) : String.valueOf(log_string) + "???"))))));
        } else if (data >= 32 && data < 128) {
            log_string = String.valueOf(log_string) + "'" + (char)data + "'";
        }
        this.log(log_string);
    }

    protected void logState(String text) {
        this.portLastValue = this.getPortValue();
        if (this.is_state_log_enabled) {
            String state = "A:" + (this.iecWorld.getAtnIn() ? "T" : "F") + " C:" + (this.iecWorld.getClkIn() ? "T" : "F") + " D:" + (this.iecWorld.getDataIn() ? "T" : "F") + " T(" + (this.clock.getTicks() - this.lastClock) + ")" + " - " + text;
            this.log(state);
            this.lastClock = this.clock.getTicks();
        }
    }

    void log(String line) {
        this.log.writeln(line);
    }

    public void addLogObserver(Observer o) {
        this.log.addObserver(o);
    }

    public void deleteLogObserver(Observer o) {
        this.log.deleteObserver(o);
    }

    public String getLogLine() {
        return this.log.getLogLine();
    }

    public void setStateLogEnabled(boolean enabled) {
        this.is_state_log_enabled = enabled;
    }

    public boolean isStateLogEnabled() {
        return this.is_state_log_enabled;
    }

    public void initSend(IecSimDevice iecSimDevice) {
        logger.debug("initSend from device " + iecSimDevice);
        this.iecWorld.BEGIN_SEND.execute();
    }

    public void initReceive(IecSimDevice iecSimDevice) {
        logger.debug("initReceive from device " + iecSimDevice);
        this.iecWorld.BEGIN_RECEIVE.execute();
    }

    public class DeviceRegistryObserver
    implements Observer {
        @Override
        public void update(Observable arg0, Object arg1) {
            IecSim.this.initDevices();
        }
    }

    private class LogEffect
    implements Effect {
        private String _text;

        LogEffect(String text) {
            this._text = text;
        }

        @Override
        public void execute() {
            IecSim.this.logState(this._text);
        }
    }

    private class ProcessBuffer
    implements Effect {
        private boolean _isAtn;

        ProcessBuffer(boolean isAtn) {
            this._isAtn = isAtn;
        }

        @Override
        public void execute() {
            IecSim.this.buffer.flip();
            IecSim.this.processData(this._isAtn);
        }
    }

    private class ReportByteEffect
    implements Effect {
        private String _direction;
        private boolean _isAtn;

        ReportByteEffect(String direction, boolean isAtn) {
            this._direction = direction;
            this._isAtn = isAtn;
        }

        @Override
        public void execute() {
            IecSim.this.reportByte(this._direction, this._isAtn, IecSim.this.iecWorld.getDataByte());
        }
    }
}

